/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynamicFetch
extends Fetch {
    protected Set<Integer> skipCols;
    protected ResultSet resultSet;

    public DynamicFetch(DataHandler dataHandler) {
        super(dataHandler);
    }

    @Override
    public void add(ResultSet resultSet) {
        this.add(resultSet, null);
    }

    @Override
    public void add(ResultSet resultSet, Set<Integer> set) {
        if (this.resultSet != null) {
            throw zxJDBC.makeException(zxJDBC.getString("onlyOneResultSet"));
        }
        try {
            if (resultSet != null && resultSet.getMetaData() != null) {
                if (this.description == Py.None) {
                    this.description = this.createDescription(resultSet.getMetaData());
                }
                this.resultSet = resultSet;
                this.skipCols = set;
                this.rowcount = 0;
                this.rownumber = 0;
            }
        }
        catch (PyException pyException) {
            throw pyException;
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
    }

    @Override
    public void add(CallableStatement callableStatement, Procedure procedure, PyObject pyObject) {
        throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nocallprocsupport"));
    }

    @Override
    public PyObject fetchall() {
        return this.fetch(0, true);
    }

    @Override
    public PyObject fetchmany(int n) {
        return this.fetch(n, false);
    }

    private PyObject fetch(int n, boolean bl) {
        PyList pyList = new PyList();
        if (this.resultSet == null) {
            throw zxJDBC.makeException(zxJDBC.DatabaseError, "no results");
        }
        try {
            boolean bl2 = bl = n < 0 ? true : bl;
            while ((n-- > 0 || bl) && this.resultSet.next()) {
                PyTuple pyTuple = this.createResult(this.resultSet, this.skipCols, this.description);
                pyList.append(pyTuple);
                ++this.rowcount;
                this.rownumber = this.resultSet.getRow();
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nodynamiccursors"));
        }
        catch (PyException pyException) {
            throw pyException;
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
        return pyList;
    }

    @Override
    public PyObject nextset() {
        return Py.None;
    }

    @Override
    public void scroll(int n, String string) {
        try {
            int n2 = this.resultSet.getType();
            if (n2 != 1003 || n > 0) {
                if ("relative".equals(string)) {
                    if (n < 0) {
                        n = Math.abs(this.rownumber + n);
                    } else if (n > 0) {
                        n = this.rownumber + n + 1;
                    }
                } else if ("absolute".equals(string)) {
                    if (n < 0) {
                        throw zxJDBC.makeException(Py.IndexError, "cursor index [" + n + "] out of range");
                    }
                } else {
                    throw zxJDBC.makeException(zxJDBC.ProgrammingError, "invalid cursor scroll mode [" + string + "]");
                }
                if (n == 0) {
                    this.resultSet.beforeFirst();
                } else if (!this.resultSet.absolute(n)) {
                    throw zxJDBC.makeException(Py.IndexError, "cursor index [" + n + "] out of range");
                }
            } else {
                String string2 = "dynamic result set of type [" + n2 + "] does not support scrolling";
                throw zxJDBC.makeException(zxJDBC.NotSupportedError, string2);
            }
            this.rownumber = this.resultSet.getRow();
        }
        catch (AbstractMethodError abstractMethodError) {
            throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("nodynamiccursors"));
        }
        catch (SQLException sQLException) {
            throw zxJDBC.makeException(sQLException);
        }
        catch (Throwable throwable) {
            throw zxJDBC.makeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        super.close();
        if (this.resultSet == null) {
            return;
        }
        this.rownumber = -1;
        try {
            this.resultSet.close();
        }
        finally {
            this.resultSet = null;
        }
    }
}

